/**
 * \file: KeyboardHelper.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Test
 *
 * \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef KEYBOARDHELPER_H
#define KEYBOARDHELPER_H

#include <atomic>
#include <string>

namespace adit { namespace aauto {

class IKeyboardReceiver
{
public:
    virtual ~IKeyboardReceiver() {};

    virtual void OnKey(uint16_t inKeyCode, bool inPressed) = 0;
    virtual void display() = 0;

};

class KeyboardHelper
{
public:
    KeyboardHelper();
    virtual ~KeyboardHelper();

    bool Start(IKeyboardReceiver* inReceiver);
    void Stop();
    bool getDetection() { return isDetection; }

private:
    bool isDetection;
    std::atomic<bool> running;
    int fd;
    pthread_t thread;
    IKeyboardReceiver* receiver;

    static void* process(void* inData);
    bool selectKeyboard(std::string& outInterface, std::string& outName);
    bool readKeyEvent(KeyboardHelper* reader);
    bool isKeyPressEvent(struct input_event Event[]);
};

} } /* namespace adit { namespace aauto */

#endif /* KEYBOARDHELPER_H */
